<%@ taglib uri="http://jakarta.apache.org/taglibs/bsf-2.0" prefix="bsf" %>

<bsf:scriptlet language="rexx">

session = bsf.lookupBean("session")
request = bsf.lookupBean("request")
response = bsf.lookupBean("response")

firstName = request~getParameter("firstName")
lastName = request~getParameter("lastName")
birthdayCal = request~getParameter("birthday") 

/* rexx-style string tokenization */
parse var birthdayCal birthday "/" birthmonth "/" birthyear 

/* creates new instance */
birthdayCalendar = .bsf~new("java.util.GregorianCalendar") 
birthdayCalendar~set(birthyear, birthmonth - 1, birthday)

/* saves new person */
newPerson = .bsf~new("org.apache.taglibs.extended.script.samples.Person", 0, firstName, lastName, birthdayCalendar)
session~getAttribute("personService")~saveOrUpdatePerson(newPerson)


/* return to start page */
response~sendRedirect("RexxController")

::REQUIRES BSF.CLS
</bsf:scriptlet>